/****** Object:  UserDefinedFunction [dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_XML_GRAVACAO_VLR_ICMS_DESONERADO]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_XML_GRAVACAO_VLR_ICMS_DESONERADO]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_XML_GRAVACAO_VLR_ICMS_DESONERADO]
GO 

/****** Object:  UserDefinedFunction [dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_DADOS_DO_XML]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_DADOS_DO_XML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_DADOS_DO_XML]
GO 

--SELECT * FROM dbo.UFD_EST_NF_ENT_DANFE_PROVISORIO_DADOS_DO_XML (913786,0,39305)
CREATE FUNCTION   [dbo].[UFD_EST_NF_ENT_DANFE_PROVISORIO_DADOS_DO_XML](@CD_CTR INT, @CAB_IT INT=0, @CD_PROD VARCHAR(100))  
RETURNS @RSRETORNO TABLE( CD_CTR INT, 
						CD_PROD VARCHAR(100),   
						CST  VARCHAR(5),
						VLR_BASE_ICMS MONEY,
						VLR_ICMS MONEY,
						VLR_BASE_SUBS MONEY,
						VLR_ICMS_SUBS MONEY,
						VLR_ICMS_DESON MONEY, 
						PERC_DIFERIMENTO MONEY, 
						VLR_ICMS_DIFERIMENTO MONEY, 
						VLR_ICMS_OP MONEY, 
						VLR_TOT_PROD MONEY,
						VLR_NF MONEY)
AS  
 BEGIN

DECLARE @RS_TEMP TABLE( CD_CTR INT, 
						CD_PROD VARCHAR(100),   
						CST  VARCHAR(5),
						VLR_BASE_ICMS MONEY,
						VLR_ICMS MONEY,
						VLR_BASE_SUBS MONEY,
						VLR_ICMS_SUBS MONEY,
						VLR_ICMS_DESON MONEY, 
						PERC_DIFERIMENTO MONEY, 
						VLR_ICMS_DIFERIMENTO MONEY, 
						VLR_ICMS_OP MONEY, 
						VLR_TOT_PROD MONEY,
						VLR_NF MONEY)

	DECLARE @Nfe  AS xml 
	SET @Nfe=(SELECT CONVERT(xml, ARQUIVO_DANFE)
	FROM 
		EST_NF_ENT_ARQ_DANFE
	WHERE 
		cd_ctr_danfe_prov = @CD_CTR)  
	IF @CAB_IT =0 --ITENS
	BEGIN
	;WITH XMLNAMESPACES(DEFAULT 'http://www.portalfiscal.inf.br/nfe') 
	INSERT INTO @RS_TEMP
	SELECT
		@CD_CTR
		,NFe.value('prod[1]/cProd [1]', 'VARCHAR(100)') AS CD_PROD
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/CST) [1]', 'varchar(5)'),0) AS CST
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vBC) [1]', 'money'),0) AS VLR_BASE_ICMS
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vICMS) [1]', 'money'),0) AS VLR_ICMS
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vBCST) [1]', 'money'),0) AS VLR_BASE_ST
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vICMSST) [1]', 'money'),0) AS VLR_ICMS_ST
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vICMSDeson) [1]', 'money'),0) AS VLR_ICMS_DESON
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/pDif) [1]', 'money'),0) AS PERC_DIFERIMENTO
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vICMSDif) [1]', 'money'),0) AS VLR_ICMS_DIFERIMENTO
		, ISNULL(NFe.value('(imposto[1]/ICMS[1]/*/vICMSOp) [1]', 'money'),0) AS VLR_ICMS_OP
		,0 AS VLR_TOT_PROD
		,0 AS VLR_NF
	FROM 
		@Nfe.nodes('//infNFe/det') AS NFes(NFe)  
	END
	ELSE
	BEGIN
	;WITH XMLNAMESPACES(DEFAULT 'http://www.portalfiscal.inf.br/nfe') 
	INSERT INTO @RS_TEMP
	SELECT
		@CD_CTR
		,0 AS CD_PROD		
		,'CAB' AS CST
		, NFe.value('(ICMSTot/vBC) [1]', 'money') AS VLR_BASE_ICMS
		, NFe.value('(ICMSTot/vICMS) [1]', 'money') AS VLR_ICMS
		, NFe.value('(ICMSTot/vBCST) [1]', 'money') AS VLR_BASE_SUBS
		, NFe.value('(ICMSTot/vST) [1]', 'money') AS VLR_ICMS_SUBS
		, 0 AS VLR_ICMS_DESON
		,0 AS PERC_DIFERIMENTO
		, 0 AS VLR_ICMS_DIFERIMENTO
		, 0 AS VLR_ICMS_OP
		, NFe.value('(ICMSTot/vProd) [1]', 'money') AS VLR_TOT_PROD
		, NFe.value('(ICMSTot/vNF) [1]', 'money') AS VLR_NF
	FROM 
		@Nfe.nodes('//infNFe/total') AS NFes(NFe) 
	END

INSERT INTO @RSRETORNO
SELECT
    *
FROM
    @RS_TEMP
WHERE
    CD_PROD =@CD_PROD
RETURN;
END


